/*  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 *  The config for charts
 *  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 */

Highcharts.theme = {
	colors: ['#058DC7', '#50B432', '#ED561B', '#DDDF00', '#24CBE5', '#64E572',
             '#FF9655', '#FFF263', '#6AF9C4'],
	chart: {
		spacing: [20, 10, 15, 10],
		backgroundColor: {
			linearGradient: {
				x1: 0,
				y1: 0,
				x2: 0,
				y2: 1
			},
			stops: [
				[0, 'var(--color8)'],
				[0.8, 'var(--color9)'],
				[1, 'var(--color8)']
				]
			},
			borderWidth: 0,
			plotBackgroundColor: '#fff'
		},
		navigator: {
			maskFill: 'var(--modal)',
			maskInside: false,
			margin: 35,
			xAxis: {
				labels: { 
					useHTML: true,
					y: -46,
					align:'center', 
					margin:30, 
					style: { color: 'var(--color1)'}
				}
			},
			handles: {
				backgroundColor: 'var(--color5)',
				borderColor: 'var(--color1)'
			}	
		},
		title: {
			style: {
				color: 'var(--color2)',
				font: 'bold font-size: clamp(1.25rem, 1.0625rem + 0.75vw, 1.625rem); "Red Rose", Verdana, sans-serif'
			}
		},
		xAxis: {
			labels: {
				style: {
					color: 'var(--color2)'
				}
			},
			title: {
				style: {
					color: 'var(--color2)'
				}
			}
		},
		yAxis: {
			labels: {
				style: {
					color: 'var(--color2)'
				}
			},
			title: {
				style: {
					color: 'var(--color2)'
				}
			}
		},
		legend: {
			itemStyle: {
				color: 'var(--color2)'
			},
		labels: {
			style: {
				color: 'var(--color2)'
			}
		},
		rangeSelector: {
			labelStyle: { color: 'var(--color2)'}
		}
	}
}

Highcharts.setOptions(Highcharts.theme);
